#include <bits/stdc++.h>

#define MAX 155
#define MX 1510
#define MAXK 3010

using namespace std;

bool dp[MAX][MAX][MAXK], wall[MX][MX], visited[MX][MX];

pair<bool, string> dfs(int i, int j, int n, int m) {

    if(i >= n || j >= m || wall[i][j] || visited[i][j])
        return {false, ""};
    if(i == n - 1 && j == m - 1)
        return {true, ""};

    visited[i][j] = true;
    auto a = dfs(i + 1, j, n, m);
    if(a.first)
        return {true, a.second + "S"};
    auto b = dfs(i, j + 1, n, m);
    if(b.first)
        return {true, b.second + "D"};
    return {false, ""};
}

void solve(int z) {

    int n, m, k;
    cin >> n >> m >> k;

    string mat[n];
    for(int i = 0; i < n; i++)
        cin >> mat[i];

    if(k == 0) {
        for(int i = 0; i < n; i++)
            for(int j = 0; j < m; j++)
                wall[i][j] = (mat[i][j] == '1'), visited[i][j] = false;
        auto sklj = dfs(0, 0, n, m);
        if(sklj.first) {
            cout << "DA" << endl;
            if(z) {
                for(int i = sklj.second.size() - 1; i >= 0; i--)
                    cout << sklj.second[i];
                cout << endl;
            }
            return;
        }
        cout << "NE" << endl;
        return;
    }

    int x1 = -1, y1, x2, y2;
    for(int i = 0; i < n; i++) {
        for(int j = 0; j < m; j++) {
            if(mat[i][j] == '1') {
                x2 = i;
                y2 = j;
                if(x1 == -1) {
                    x1 = i;
                    y1 = j;
                }
            }
        }
    }
    bool tst = true;
    for(int i = 0; i < n; i++) {
        for(int j = 0; j < m; j++)
            if(mat[i][j] == '1')
                if(i < x1 || x2 < i || j < y1 || y2 < j)
                    tst = false;
            if(x1 <= i && i <= x2 && y1 <= j && j <= y2)
                if(mat[i][j] != '1')
                    tst = false;
    }
    if(tst && z == 0) {
        if(k > x2 - x1 + y2 - y1 + 1)
            cout << "NE" << endl;
        else
            cout << "DA" << endl;
        return;
    }

    for(int i = 0; i <= n; i++) {
        for(int j = 0; j <= m; j++) {
            if(i == 1 && j == 1) {
                for(int l = 0; l <= k; l++)
                    dp[i][j][l] = false;
                if(mat[i - 1][j - 1] == '1')
                    dp[i][j][1] = true;
                else
                    dp[i][j][0] = true;
                continue;
            }
            for(int l = 0; l <= k; l++) {
                if(i == 0 || j == 0) {
                    dp[i][j][l] = false;
                    continue;
                }

                if(mat[i - 1][j - 1] == '1')
                    dp[i][j][l] = (l == 0 ? false : (dp[i - 1][j][l - 1] || dp[i][j - 1][l - 1]));
                else
                    dp[i][j][l] = (dp[i - 1][j][l] || dp[i][j - 1][l]);
            }
        }
    }
    cout << (dp[n][m][k] ? "DA" : "NE") << endl;
    if(dp[n][m][k] && z) {
        stack<char> sol;
        int i = n, j = m, l = k;
        while(i > 1 || j > 1) {
            if(mat[i - 1][j - 1] == '1')
                if(dp[i - 1][j][l - 1])
                    sol.push('S'), i--, l--;
                else
                    sol.push('D'), j--, l--;
            else
                if(dp[i - 1][j][l])
                    sol.push('S'), i--;
                else
                    sol.push('D'), j--;
        }

        while(!sol.empty()) {
            cout << sol.top();
            sol.pop();
        }
        cout << endl;
    }
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int t, z;
    cin >> t >> z;
    while(t--)
        solve(z);
    return 0;
}

/*
3 1
3 3 1
000
000
100
3 3 2
001
010
100
3 4 0
0011
1000
1100
*/